	%	 Ex 12.18
	close all, clear all, clc
	N = 12; M = 0; Nband = 3;
	Be =[0 0.2 0.25 0.4 0.45 1]*pi; 	% Band edges
	PhaseDiff = [0, -1, 0]*pi;			% Stopband filter
	 
	W = [22, 1, 2]; 
	[Z1, P1, Z2, P2, Att] = SYM_WDF(N,M,Nband,Be,PhaseDiff,W);
	 
	fprintf('\n Bandpass filter \n')	
	for n = 1:Nband		
		fprintf('%1.0f. band  %2.12f dB \n',n, POWER_COMP(Att(n)));	
	end 
	fprintf('\n')
	wT = linspace(0, pi, 1000);
	P = [P1;P2];
	alfa = CT_TREE_WDF_BP(P);
	[s11, s21] = CT_TREE_WDF_BP_H(alfa, wT);
	Att = H_2_ATT(s21);
	figure(1); subplot(2,1,1)
	PLOT_ATT_Z(wT, Att, pi, 80), zoom on
 	
